#region References

using System;
using System.Collections;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;
using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.ExceptionManagement;
using gov.va.med.vbecs.GUI.controls;
using gov.va.med.vbecs.Common;

#endregion
//
namespace gov.va.med.vbecs.GUI
{
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>John Vrooland</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>1/21/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///
	/// <summary>
	/// Main for for process shipment, processes an outgoing shipment,
	/// prints invoices, etc.
	/// </summary>
	public class FrmProcessShipmentOut : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private const string DisabledBtnMessage = "Please Save first";
		private const string SaveBtnMessage = "There are no changes to save";

		private const Common.WorkloadProcessID _workloadProcessID = Common.WorkloadProcessID.UnitLogout;
		//
		private BOL.OutgoingShipmentCollection _currentInvoice;
		private static Hashtable _invoices = new Hashtable();
		//
		private bool _useNewInvoice;
		private bool _refreshLineItem;

		//Holder for all the units (BloodUnitFinanceGuid values) attached to invoice on formload
		private System.Collections.ArrayList _existingUnits = new System.Collections.ArrayList();
	    private bool _removeItem;
		//
		#region Form Controls

		private gov.va.med.vbecs.GUI.controls.InvoiceDisplayPanel invoiceDisplayPanel1;
		private System.Windows.Forms.Button                       btnCancel;
		private System.ComponentModel.IContainer                  components;
		private System.Windows.Forms.GroupBox                     groupBox1;
		private System.Windows.Forms.ListView                     lvSelectedUnits;
		private gov.va.med.vbecs.GUI.controls.BloodUnitSelector   bloodUnitSelector1;
		private System.Windows.Forms.ColumnHeader                 colCheckBox;
		private System.Windows.Forms.ColumnHeader                 colUnitId;
		private System.Windows.Forms.ColumnHeader                 colProduct;
		private System.Windows.Forms.ColumnHeader                 colAboRh;
		private System.Windows.Forms.ColumnHeader                 colExpirationDate;
		private System.Windows.Forms.ColumnHeader                 colDonationType;
		private System.Windows.Forms.ColumnHeader                 colStatus;
		private System.Windows.Forms.ColumnHeader                 colReceivedDate;
		private System.Windows.Forms.ColumnHeader                 colQuarantined;
		private System.Windows.Forms.ColumnHeader                 colPatient;
		private System.Windows.Forms.ColumnHeader                 colReturnCredit;
		private System.Windows.Forms.ImageList                    imageList1;
		private System.Windows.Forms.ColumnHeader                 colBiohazardous;
		private System.Windows.Forms.MenuItem                     menuItemReturnCredit;
		private System.Windows.Forms.MenuItem                     menuItemRemoveUnit;
		private System.Windows.Forms.ContextMenu                  menuUnitItem;
		private System.Windows.Forms.Panel pnlButtons;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnCancelShipment;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnConfirm;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnPrintInvoice;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;

		#endregion

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///
		/// <summary>
		/// Private empty constructor.
		/// </summary>
		private FrmProcessShipmentOut() : base()
		{
		    _removeItem = false;
			this.LockController.LockFunction = Common.LockFunctions.UC011OutgoingShipment;
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			//
			SetComponentProperties();
			//
			this.OnVbecsStatusChange += new VbecsBaseForm.VbecsStatusEventHandler(VbecsStatusChange);
			//
			this._refreshLineItem = false;
			this.invoiceDisplayPanel1.Focus();
		}
		
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///
		/// <summary>
		/// Public constructor taking parent form and initial use indicator.
		/// 
		/// </summary>
		/// <param name="useNew"></param>
		public FrmProcessShipmentOut(bool useNew) : this()
		{
			//
			this._useNewInvoice = useNew;
			//
			InitializeShipmentOut();
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///
		/// <summary>
		/// Public constructor taking initial use indicator and Invoice
		/// 
		/// </summary>
		/// <param name="useNew"></param>
		/// <param name="invoice"></param>
		public FrmProcessShipmentOut(bool useNew, 
			BOL.OutgoingShipmentCollection invoice) : this()
		{
			if (!this.SetLocks(invoice.ShipmentGuid))
			{
				this.DialogResult = DialogResult.Abort;
				return;
			}

			this._useNewInvoice = useNew;
			this._currentInvoice = new OutgoingShipmentCollection(invoice.ShipmentGuid);
			// Setting the IsDirtyChanged event to fire the SetDirtyFlag function
			// Everytime a property of the variable is altered and thus the form
			// has been changed in one way or another.
			this._currentInvoice.IsDirtyChanged += new System.EventHandler(SetDirtyFlag);
			this._currentInvoice.Invalid += new System.EventHandler(this.SetDirtyFlag);   
			//
			InitializeShipmentOut();
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///
		/// <summary>
		/// Retrieve the invoice we will be working with, populate listview
		/// with any units assigned.
		/// </summary>
		//
		private void InitializeShipmentOut()
		{
			DlgShipmentOut shipmentOut;
			try
			{
				if ( _currentInvoice == null )
				{
					DataTable dtInvoices = BOL.OutgoingShipmentCollection.GetRecentInvoicesForDivision();
					shipmentOut = new DlgShipmentOut(_useNewInvoice, dtInvoices);
					shipmentOut.ShowDialogFromLockedParent(this, false);
					//
					if ( shipmentOut.DialogResult == DialogResult.Cancel )
					{
						this.Close();
						return;
					}
					//
					GetSelectedInvoice(shipmentOut);
				}
				//
				if ( _invoices.ContainsKey(_currentInvoice.ShipmentGuid.ToString()) )
				{
					GuiMessenger.ShowMessageBox(this, Common.StrRes.SysErrMsg.UC011.InvoiceAlreadyOpen(_currentInvoice.InvoiceNumber));
					_currentInvoice = null;
					this.Close();
					return;
				}
				lock (_invoices) 
				{
					_invoices.Add(_currentInvoice.ShipmentGuid.ToString(),_currentInvoice);
				}
				SetUpUIElements();
				//
			} 
			catch ( Exception ex )
			{
				ExceptionManager.Publish(ex);
				GuiMessenger.ShowMessageBox(this, Common.StrRes.SysErrMsg.Common.Dynamic(ex.Message));
#if DEBUG
				throw ex;
#else
                this.Close();
#endif
			}
		}

		private void SetUpUIElements()
		{
			if ( !_currentInvoice.Confirmed )
			{
				UseNonConfirmedSettings();
			} 
			else
			{
				UseConfirmedSettings();
			}
			invoiceDisplayPanel1.Invoice = _currentInvoice;
			invoiceDisplayPanel1.IncomingShipment = false;
			//
			foreach(OutgoingShipmentCollection.LineItem li in _currentInvoice.Values) 
			{
				this._existingUnits.Add(li.BloodUnitFinance.BloodUnitFinanceGuid);
				AddLineItemToListView(li);
			}
			//
			gov.va.med.vbecs.GUI.controls.VbecsFunction.SetColumnWidths(lvSelectedUnits);
			this.invoiceDisplayPanel1.Focus();
		}
		//
		private void UseNonConfirmedSettings()
		{
			ArrayList lineItemsToBeRemoved = new ArrayList();
			RegisterHandlers(_currentInvoice);
			if ( _currentInvoice.Count > 0 )
			{
				btnCancelShipment.EnabledButton = true;
				btnCancelShipment.SetToolTip(String.Empty);
				//
				btnConfirm.EnabledButton= true;
				btnConfirm.SetToolTip(String.Empty);
				//
				btnPrintInvoice.EnabledButton = true;
				btnPrintInvoice.SetToolTip(String.Empty);
			}
			else
			{
				btnCancelShipment.EnabledButton = false;
				btnCancelShipment.SetToolTip(Common.StrRes.Tooltips.Common.NoUnitsSelected().ResString);
				//
				btnConfirm.EnabledButton= false;
				btnConfirm.SetToolTip(Common.StrRes.Tooltips.Common.NoUnitsSelected().ResString);
				//
				btnPrintInvoice.EnabledButton = false;
				btnPrintInvoice.SetToolTip(Common.StrRes.Tooltips.Common.NoUnitsSelected().ResString);
			}
			foreach (OutgoingShipmentCollection.LineItem li in _currentInvoice.Values)
			{
				if ( !VerifyUnitEligibleForShipment(li) )
				{	
					// This looks right, but is not.  A collection cannot be
					// added to (or deleted from) under iteration.
					// _currentInvoice.RemoveUnitFromInvoice(li);

					// Instead, build a collection and remove later.
					lineItemsToBeRemoved.Add(li);
				}
			}

			foreach(BOL.OutgoingShipmentCollection.LineItem li in lineItemsToBeRemoved)
			{
				this._currentInvoice.RemoveUnitFromInvoice(li);
			}
			//
		}

		private void GetSelectedInvoice(DlgShipmentOut shipmentOut)
		{
			if ( shipmentOut.IsNewInvoice )
			{
				_currentInvoice = BOL.OutgoingShipmentCollection.CreateOutgoingInvoice(shipmentOut.InvoiceNumber,
					shipmentOut.LocalSupplierGuid,
					shipmentOut.ShipmentDate,
					shipmentOut.ShipmentType,
					ThisUser.UserNTLoginID,
					Common.UpdateFunction.UC011FrmProcessShipmentOut);
			} 
			else
			{
				_currentInvoice = shipmentOut.OutgoingShipment;
			}
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///
		/// <summary>
		/// Destructor for this form
		/// </summary>
		~FrmProcessShipmentOut()
		{
			this.Dispose(true);
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///
		/// <summary>
		/// Set up for an already confirmed invoice.
		/// </summary>
		private void UseConfirmedSettings()
		{
			//
			UnRegisterHandlers(_currentInvoice);
			//
			bloodUnitSelector1.Enabled = false;
			lvSelectedUnits.CheckBoxes = false;
			//
			btnPrintInvoice.EnabledButton = true;
			btnPrintInvoice.SetToolTip(String.Empty);
			//
			btnConfirm.EnabledButton = false;
			btnConfirm.SetToolTip(FrmProcessShipmentOut.DisabledBtnMessage);
			//
			btnOK.EnabledButton = false;
			btnOK.SetToolTip(FrmProcessShipmentOut.SaveBtnMessage);
			//
			btnCancelShipment.EnabledButton = false;
			btnCancelShipment.SetToolTip(FrmProcessShipmentOut.DisabledBtnMessage);
			//
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// Set the event handlers for notification of interesting events.
		/// </summary>
		/// <param name="invoice"></param>
		private void RegisterHandlers(BOL.OutgoingShipmentCollection invoice) 
		{
			invoice.InErrorStateChanged += new EventHandler(this.InErrorStateChangedHandler);
			invoice.ReadyToSaveChanged += new OutgoingShipmentCollection.ReadyToSaveChangedEventHandler(this.ReadyToSaveChangedHandler);
			invoice.ReadyToConfirmChanged += new OutgoingShipmentCollection.ReadyToConfirmChangedEventHandler(this.ReadyToConfirmChangedHandler);
			invoice.ReadyToPrintChanged += new OutgoingShipmentCollection.ReadyToPrintChangedEventHandler(this.ReadyToPrintChangedHandler);
			invoice.CanceledChanged += new OutgoingShipmentCollection.CanceledChangedEventHandler(this.CanceledChangedHandler);
			invoice.SavedChanged += new OutgoingShipmentCollection.SavedChangedEventHandler(this.SavedChangedHandler);
			invoice.ConfirmedChanged += new OutgoingShipmentCollection.ConfirmedChangedEventHandler(this.ConfirmedChangedHandler);
			//Setting the IsDirtyChanged event to fire the SetDirtyFlag function
			//Everytime a property of the variable is altered and thus the form
			//has been changed in one way or another.
			invoice.IsDirtyChanged += new System.EventHandler(SetDirtyFlag);
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// Remove event handlers, unneeded for a confirmed invoice.
		/// </summary>
		/// <param name="invoice"></param>
		private void UnRegisterHandlers(BOL.OutgoingShipmentCollection invoice) 
		{
			invoice.InErrorStateChanged -= new EventHandler(this.InErrorStateChangedHandler);
			invoice.ReadyToSaveChanged -= new OutgoingShipmentCollection.ReadyToSaveChangedEventHandler(this.ReadyToSaveChangedHandler);
			invoice.ReadyToConfirmChanged -= new OutgoingShipmentCollection.ReadyToConfirmChangedEventHandler(this.ReadyToConfirmChangedHandler);
			invoice.ReadyToPrintChanged -= new OutgoingShipmentCollection.ReadyToPrintChangedEventHandler(this.ReadyToPrintChangedHandler);
			invoice.CanceledChanged -= new OutgoingShipmentCollection.CanceledChangedEventHandler(this.CanceledChangedHandler);
			invoice.SavedChanged -= new OutgoingShipmentCollection.SavedChangedEventHandler(this.SavedChangedHandler);
			invoice.ConfirmedChanged -= new OutgoingShipmentCollection.ConfirmedChangedEventHandler(this.ConfirmedChangedHandler);
			invoice.IsDirtyChanged -= new System.EventHandler(SetDirtyFlag);
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// Invoice has been modified. Show the Save button.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		public void ReadyToSaveChangedHandler(object sender, BOL.OutgoingShipmentCollection.ReadyToSaveChangedEventArgs e) 
		{
			btnOK.EnabledButton = e.ReadyToSave;
			if (btnOK.EnabledButton) btnOK.SetToolTip(String.Empty);
			else btnOK.SetToolTip(FrmProcessShipmentOut.SaveBtnMessage);
			//
			btnCancelShipment.EnabledButton = !e.ReadyToSave && _currentInvoice.Count > 0;
			if (btnCancelShipment.EnabledButton) btnCancelShipment.SetToolTip(String.Empty);
			else btnCancelShipment.SetToolTip(FrmProcessShipmentOut.DisabledBtnMessage);
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// Invoice has been modified elsewhere while we were working on it.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		public void InErrorStateChangedHandler(object sender, System.EventArgs e) 
		{
			if ( _currentInvoice.InErrorState || _currentInvoice == null )
			{
				// DWA 07/15/05 Throwing exception here for now; this code should never be called
				throw new Exception("Warning! InErrorStateChangedHandler: unused code!");
			}
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// Handle the change in confirmable state  
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		public void ReadyToConfirmChangedHandler(object sender, BOL.OutgoingShipmentCollection.ReadyToConfirmChangedEventArgs e) 
		{
			btnConfirm.EnabledButton = e.ReadyToConfirm;
			if (btnConfirm.EnabledButton) btnConfirm.SetToolTip(String.Empty);
			else btnConfirm.SetToolTip(FrmProcessShipmentOut.DisabledBtnMessage);
			//
			btnCancelShipment.EnabledButton = e.ReadyToConfirm;
			if (btnCancelShipment.EnabledButton) btnCancelShipment.SetToolTip(String.Empty);
			else btnCancelShipment.SetToolTip(FrmProcessShipmentOut.DisabledBtnMessage);
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// Handle the printable state
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		public void ReadyToPrintChangedHandler(object sender, BOL.OutgoingShipmentCollection.ReadyToPrintChangedEventArgs e) 
		{
			btnPrintInvoice.EnabledButton = e.ReadyToPrint;
			if (btnPrintInvoice.EnabledButton) btnPrintInvoice.SetToolTip(String.Empty);
			else btnPrintInvoice.SetToolTip(FrmProcessShipmentOut.DisabledBtnMessage);
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// Handle the cancel event
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		public void CanceledChangedHandler(object sender, BOL.OutgoingShipmentCollection.CanceledChangedEventArgs e) 
		{
			if ( e.Canceled )
			{
				lvSelectedUnits.Items.Clear();
				_currentInvoice.RemoveAllUnitsFromThisInvoice(Common.UpdateFunction.UC011FrmProcessShipmentOut);
				invoiceDisplayPanel1.Invoice = null;
				this.Close();
			}
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// Handle the saved event
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		public void SavedChangedHandler(object sender, 
			BOL.OutgoingShipmentCollection.SavedChangedEventArgs e) 
		{
			this.btnConfirm.EnabledButton = e.Saved && this._currentInvoice.Count > 0;
			if (btnConfirm.EnabledButton) btnConfirm.SetToolTip(String.Empty);
			else btnConfirm.SetToolTip(FrmProcessShipmentOut.DisabledBtnMessage);
			//

			this.btnOK.EnabledButton = !e.Saved;
			if (btnOK.EnabledButton) btnCancelShipment.SetToolTip(String.Empty);
			else btnOK.SetToolTip(FrmProcessShipmentOut.SaveBtnMessage);
			//
			this.btnCancelShipment.EnabledButton = (!_currentInvoice.Confirmed) && e.Saved && this._currentInvoice.Count > 0;
			if (btnCancelShipment.EnabledButton) btnCancelShipment.SetToolTip(String.Empty);
			else btnCancelShipment.SetToolTip(FrmProcessShipmentOut.DisabledBtnMessage);
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// Handle the confirmed event
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		public void ConfirmedChangedHandler(object sender, BOL.OutgoingShipmentCollection.ConfirmedChangedEventArgs e) 
		{
			if ( e.Confirmed )
			{
				UseConfirmedSettings();
			}
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			Debug.WriteLine("FrmProcessShipmentOut Disposing");
			if ( disposing )
			{
				if ( components != null )
				{
					components.Dispose();
					components = null;
				}
				if ( _currentInvoice != null )
				{
					lock (this) 
					{
						_invoices.Remove(_currentInvoice.ShipmentGuid.ToString());
					}
					_currentInvoice.Dispose();
					_currentInvoice = null;
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmProcessShipmentOut));
            this.invoiceDisplayPanel1 = new gov.va.med.vbecs.GUI.controls.InvoiceDisplayPanel();
            this.btnCancel = new System.Windows.Forms.Button();
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this.lvSelectedUnits = new System.Windows.Forms.ListView();
            this.colCheckBox = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colUnitId = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colProduct = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colAboRh = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colExpirationDate = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colDonationType = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colStatus = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colReceivedDate = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colPatient = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colBiohazardous = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colQuarantined = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colReturnCredit = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.menuUnitItem = new System.Windows.Forms.ContextMenu();
            this.menuItemRemoveUnit = new System.Windows.Forms.MenuItem();
            this.menuItemReturnCredit = new System.Windows.Forms.MenuItem();
            this.imageList1 = new System.Windows.Forms.ImageList(this.components);
            this.bloodUnitSelector1 = new gov.va.med.vbecs.GUI.controls.BloodUnitSelector(this.components);
            this.pnlButtons = new System.Windows.Forms.Panel();
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnPrintInvoice = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnConfirm = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnCancelShipment = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.groupBox1.SuspendLayout();
            this.pnlButtons.SuspendLayout();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(632, 30);
            this.vbecsLogo1.TabIndex = 4;
            this.vbecsLogo1.Title = "Process Outgoing Shipment";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.TabIndex = 5;
            // 
            // invoiceDisplayPanel1
            // 
            this.invoiceDisplayPanel1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.invoiceDisplayPanel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.invoiceDisplayPanel1.IncomingShipment = false;
            this.invoiceDisplayPanel1.Invoice = null;
            this.invoiceDisplayPanel1.Location = new System.Drawing.Point(3, 32);
            this.invoiceDisplayPanel1.Name = "invoiceDisplayPanel1";
            this.invoiceDisplayPanel1.Shipment = null;
            this.invoiceDisplayPanel1.Size = new System.Drawing.Size(626, 42);
            this.invoiceDisplayPanel1.TabIndex = 0;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(460, 5);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 7;
            this.btnCancel.Text = "&Cancel";
            this.ttToolTip.SetToolTip(this.btnCancel, "Cancel any unsaved changes and close");
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // groupBox1
            // 
            this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.groupBox1.Controls.Add(this.lvSelectedUnits);
            this.groupBox1.Location = new System.Drawing.Point(4, 308);
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.Size = new System.Drawing.Size(624, 132);
            this.groupBox1.TabIndex = 1;
            this.groupBox1.TabStop = false;
            this.groupBox1.Text = "Selected Units";
            // 
            // lvSelectedUnits
            // 
            this.lvSelectedUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvSelectedUnits.CheckBoxes = true;
            this.lvSelectedUnits.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.colCheckBox,
            this.colUnitId,
            this.colProduct,
            this.colAboRh,
            this.colExpirationDate,
            this.colDonationType,
            this.colStatus,
            this.colReceivedDate,
            this.colPatient,
            this.colBiohazardous,
            this.colQuarantined,
            this.colReturnCredit});
            this.lvSelectedUnits.ContextMenu = this.menuUnitItem;
            this.lvSelectedUnits.FullRowSelect = true;
            this.lvSelectedUnits.Location = new System.Drawing.Point(8, 16);
            this.lvSelectedUnits.MultiSelect = false;
            this.lvSelectedUnits.Name = "lvSelectedUnits";
            this.lvSelectedUnits.Size = new System.Drawing.Size(608, 108);
            this.lvSelectedUnits.SmallImageList = this.imageList1;
            this.lvSelectedUnits.TabIndex = 2;
            this.lvSelectedUnits.UseCompatibleStateImageBehavior = false;
            this.lvSelectedUnits.View = System.Windows.Forms.View.Details;
            this.lvSelectedUnits.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvSelectedUnits_ColumnClick);
            this.lvSelectedUnits.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvSelectedUnits_ItemCheck);
            this.lvSelectedUnits.ItemChecked += new System.Windows.Forms.ItemCheckedEventHandler(this.lvSelectedUnits_ItemChecked);
            this.lvSelectedUnits.SelectedIndexChanged += new System.EventHandler(this.lvSelectedUnits_SelectedIndexChanged);
            this.lvSelectedUnits.MouseDown += new System.Windows.Forms.MouseEventHandler(this.lvSelectedUnits_MouseDown);
            this.lvSelectedUnits.MouseMove += new System.Windows.Forms.MouseEventHandler(this.lvSelectedUnits_MouseMove);
            this.lvSelectedUnits.MouseUp += new System.Windows.Forms.MouseEventHandler(this.lvSelectedUnits_MouseUp);
            // 
            // colCheckBox
            // 
            this.colCheckBox.Text = "";
            this.colCheckBox.Width = 20;
            // 
            // colUnitId
            // 
            this.colUnitId.Text = "Unit ID";
            this.colUnitId.Width = 50;
            // 
            // colProduct
            // 
            this.colProduct.Text = "Product";
            this.colProduct.Width = 50;
            // 
            // colAboRh
            // 
            this.colAboRh.Text = "ABO/Rh";
            this.colAboRh.Width = 50;
            // 
            // colExpirationDate
            // 
            this.colExpirationDate.Text = "Expires";
            this.colExpirationDate.Width = 80;
            // 
            // colDonationType
            // 
            this.colDonationType.Text = "Donation";
            this.colDonationType.Width = 50;
            // 
            // colStatus
            // 
            this.colStatus.Text = "Status";
            this.colStatus.Width = 50;
            // 
            // colReceivedDate
            // 
            this.colReceivedDate.Text = "Date/Time Received";
            this.colReceivedDate.Width = 115;
            // 
            // colPatient
            // 
            this.colPatient.Text = "Patient";
            // 
            // colBiohazardous
            // 
            this.colBiohazardous.Text = "Biohazardous";
            // 
            // colQuarantined
            // 
            this.colQuarantined.Text = "Quarantined";
            // 
            // colReturnCredit
            // 
            this.colReturnCredit.Text = "Return Credit";
            this.colReturnCredit.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            // 
            // menuUnitItem
            // 
            this.menuUnitItem.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.menuItemRemoveUnit,
            this.menuItemReturnCredit});
            // 
            // menuItemRemoveUnit
            // 
            this.menuItemRemoveUnit.Index = 0;
            this.menuItemRemoveUnit.Text = "&Remove Unit";
            this.menuItemRemoveUnit.Click += new System.EventHandler(this.menuItemRemoveUnit_Click);
            // 
            // menuItemReturnCredit
            // 
            this.menuItemReturnCredit.Index = 1;
            this.menuItemReturnCredit.Text = "Return &Credit Update";
            this.menuItemReturnCredit.Click += new System.EventHandler(this.menuItemReturnCredit_Click);
            // 
            // imageList1
            // 
            this.imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
            this.imageList1.TransparentColor = System.Drawing.Color.Transparent;
            this.imageList1.Images.SetKeyName(0, "");
            this.imageList1.Images.SetKeyName(1, "");
            this.imageList1.Images.SetKeyName(2, "");
            this.imageList1.Images.SetKeyName(3, "");
            this.imageList1.Images.SetKeyName(4, "");
            this.imageList1.Images.SetKeyName(5, "");
            // 
            // bloodUnitSelector1
            // 
            this.bloodUnitSelector1.AdditionalSearchCriteria = gov.va.med.vbecs.Common.AdditionalBloodUnitSearchCriteria.UnitsInFinalStatus;
            this.bloodUnitSelector1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.bloodUnitSelector1.BloodUnit = null;
            this.bloodUnitSelector1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.bloodUnitSelector1.Location = new System.Drawing.Point(4, 72);
            this.bloodUnitSelector1.Name = "bloodUnitSelector1";
            this.bloodUnitSelector1.RecursionGuard = false;
            this.bloodUnitSelector1.SelectButtonEnabled = false;
            this.bloodUnitSelector1.Size = new System.Drawing.Size(624, 236);
            this.bloodUnitSelector1.TabIndex = 1;
            this.bloodUnitSelector1.UnitTable = null;
            this.bloodUnitSelector1.SelectBtnClick += new gov.va.med.vbecs.GUI.controls.BloodUnitSelector.SelectBtnClickedEventHandler(this.bloodUnitSelector1_SelectBtnClick);
            this.bloodUnitSelector1.SearchClick += new System.EventHandler(this.bloodUnitSelector1_SearchClick);
            // 
            // pnlButtons
            // 
            this.pnlButtons.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlButtons.Controls.Add(this.btnOK);
            this.pnlButtons.Controls.Add(this.btnPrintInvoice);
            this.pnlButtons.Controls.Add(this.btnConfirm);
            this.pnlButtons.Controls.Add(this.btnCancelShipment);
            this.pnlButtons.Controls.Add(this.btnCancel);
            this.pnlButtons.Location = new System.Drawing.Point(96, 440);
            this.pnlButtons.Name = "pnlButtons";
            this.pnlButtons.Size = new System.Drawing.Size(536, 32);
            this.pnlButtons.TabIndex = 2;
            // 
            // btnOK
            // 
            this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnOK.EnabledButton = false;
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
            this.btnOK.Location = new System.Drawing.Point(380, 5);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 6;
            this.ttToolTip.SetToolTip(this.btnOK, "There are no changes to save");
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            // 
            // btnPrintInvoice
            // 
            this.btnPrintInvoice.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnPrintInvoice.Image = ((System.Drawing.Image)(resources.GetObject("btnPrintInvoice.Image")));
            this.btnPrintInvoice.Location = new System.Drawing.Point(260, 5);
            this.btnPrintInvoice.Name = "btnPrintInvoice";
            this.btnPrintInvoice.Size = new System.Drawing.Size(108, 23);
            this.btnPrintInvoice.TabIndex = 5;
            this.btnPrintInvoice.Click += new System.EventHandler(this.btnPrintInvoice_Click);
            // 
            // btnConfirm
            // 
            this.btnConfirm.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnConfirm.Image = ((System.Drawing.Image)(resources.GetObject("btnConfirm.Image")));
            this.btnConfirm.Location = new System.Drawing.Point(130, 5);
            this.btnConfirm.Name = "btnConfirm";
            this.btnConfirm.Size = new System.Drawing.Size(124, 23);
            this.btnConfirm.TabIndex = 4;
            this.btnConfirm.Click += new System.EventHandler(this.btnConfirm_Click);
            // 
            // btnCancelShipment
            // 
            this.btnCancelShipment.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancelShipment.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnCancelShipment.Image = ((System.Drawing.Image)(resources.GetObject("btnCancelShipment.Image")));
            this.btnCancelShipment.Location = new System.Drawing.Point(0, 5);
            this.btnCancelShipment.Name = "btnCancelShipment";
            this.btnCancelShipment.Size = new System.Drawing.Size(124, 23);
            this.btnCancelShipment.TabIndex = 3;
            this.btnCancelShipment.Click += new System.EventHandler(this.btnCancelShipment_Click);
            // 
            // FrmProcessShipmentOut
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(632, 473);
            this.Controls.Add(this.pnlButtons);
            this.Controls.Add(this.invoiceDisplayPanel1);
            this.Controls.Add(this.bloodUnitSelector1);
            this.Controls.Add(this.groupBox1);
            this.hlphelpChm.SetHelpKeyword(this, "Outgoing_Shipment.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.MinimumSize = new System.Drawing.Size(640, 500);
            this.Name = "FrmProcessShipmentOut";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Process Outgoing Shipment";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmProcessShipmentOut_KeyDownSpeakMessage);
            this.Load += new System.EventHandler(this.FrmProcessShipmentOut_Load);
            this.Resize += new System.EventHandler(this.FrmProcessShipmentOut_Resize);
            this.Controls.SetChildIndex(this.groupBox1, 0);
            this.Controls.SetChildIndex(this.bloodUnitSelector1, 0);
            this.Controls.SetChildIndex(this.invoiceDisplayPanel1, 0);
            this.Controls.SetChildIndex(this.pnlButtons, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.groupBox1.ResumeLayout(false);
            this.pnlButtons.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		/// <summary>
		/// Set up the title bar and the invoice display.
		/// </summary>
		private void SetComponentProperties()
		{
			vbecsLogo1.Title="Process Outgoing Shipment";
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = string.Concat(Environment.CurrentDirectory, "\\VBECS.chm");
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = string.Concat(Environment.CurrentDirectory, "\\VBECS.chm");
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC011.FrmProcessShipmentOut());
			//
			invoiceDisplayPanel1.IncomingShipment = false;
			this.btnCancelShipment.Text = "Ca&ncel Shipment";
			this.btnConfirm.Text = "Confirm &Shipment";
			this.btnPrintInvoice.Text = "&Print Invoice";
			this.btnOK.Text = "&Save";
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// User has clicked the "Save" button
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{ 
			// Confirm user wants to save 
			DialogResult dialogResult = GuiMessenger.ShowMessageBox( Common.StrRes.ConfMsg.UC011.Save() );
			//
			if ( dialogResult == DialogResult.Yes )
			{
				using ( new WaitCursor() ) 
				{
					if ( _currentInvoice.IsDirty )
					{
						// If an excpetion is thrown, it will be caught by 
						// the handler in the vbecsbaseform class.
						if (!SaveChangedItems()) return;					

						// Need to reinstantiate the invoice just saved so that
						// the rowversions are retrieved from the database.
						this._currentInvoice = new OutgoingShipmentCollection(this._currentInvoice.ShipmentGuid);
				
						// The current invoice is no longer new.
						this._useNewInvoice = false;
				
						// Attach the handlers to the invoice just created.
						this.RegisterHandlers(this._currentInvoice);			
	
						//Create a new collection of lineitems, since they've saved and remain on screen
						this._existingUnits = new System.Collections.ArrayList();
						foreach(ListViewItem lvi in this.lvSelectedUnits.SelectedItems)
						{
							OutgoingShipmentCollection.LineItem li = ((OutgoingShipmentCollection.LineItem)lvi.Tag);

							this._existingUnits.Add(li.BloodUnitFinance.BloodUnitFinanceGuid);
						}
					
					} 
					else
					{
						GuiMessenger.ShowMessageBox(this, Common.StrRes.InfoMsg.UC011.NoItems());
					}
				}
			}
		}

		private bool SaveChangedItems()
		{
			try
			{
				//CR 1441
				System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) Common.WorkloadProcessID.UnitLogout);
				if(dt!= null)
				{
					if(dt.Rows.Count == 0)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
					}
				}
				ArrayList errorList = new ArrayList();                    
				_currentInvoice.SaveChangesToInvoiceItems(errorList, Common.UpdateFunction.UC011FrmProcessShipmentOut);
				if ( errorList.Count > 0 )
				{
					GuiMessenger.ShowMessageBox(this, Common.StrRes.SysErrMsg.UC011.UpdateError()); 
				} 
				//Changes have been saved, the form is no longer dirty.
				this.IsDirty=false;
				return(true);
			} 
			catch (RowVersionException)
			{
				this.btnOK.RowVersionException = true;		//CR2077
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
				//An error occured and the form needs to close, set the dirty variable
				//to false so that the user is not prompted about the unsaved data
				this.IsDirty=false;
				return(false);
			}
			
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// User has clicked the Cancel button
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// Present the form to print the invoice
		/// </summary>
		private void PrintInvoice()
		{
			DlgViewInvoice f = new DlgViewInvoice(_currentInvoice);
			f.ShowDialogFromLockedParent(this, false);
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// Present the HTML print invoice version
		/// </summary>
		private void PrintInvoiceWeb()
		{
			DlgViewInvoice f = new DlgViewInvoice(_currentInvoice);
			f.ShowDialogFromLockedParent(this, false);
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// Present the confirm shipment dialog
		/// </summary>
		private void PrintShipment()
		{
			try
			{
				BOL.OutgoingShipmentCollection invoice;
				if ( _currentInvoice.Confirmed )
				{
					invoice = _currentInvoice;
				} 
				else
				{
					invoice = BOL.OutgoingShipmentCollection.GetOutgoingInvoiceByGuid(_currentInvoice.ShipmentGuid);
				}
				DlgViewInvoice f = new DlgViewInvoice(invoice);
				f.ShowDialogFromLockedParent(this, false);
				//
			} 
			catch ( InvoiceException )
			{
				GuiMessenger.ShowMessageBox(this, Common.StrRes.SysErrMsg.UC011.UpdateError()); 
				this.Close();
			}
		}
		//
		private void VbecsStatusChange(object sender, System.EventArgs e)
		{
			//
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// User has clicked the Confirm button
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnConfirm_Click(object sender, System.EventArgs e)
		{
			using (new WaitCursor()) 
			{
				DlgGetShipmentDate dlgDate = new DlgGetShipmentDate(_currentInvoice);
				dlgDate.ShowDialogFromLockedParent(this, false);
				//
				if ( dlgDate.DialogResult == DialogResult.OK && _currentInvoice.ShipmentDate != DateTime.MinValue )
				{
					foreach(ListViewItem lvi in this.lvSelectedUnits.Items)
					{
						OutgoingShipmentCollection.LineItem lineItem = ((OutgoingShipmentCollection.LineItem)lvi.Tag);
						//CR 3166, moved code for BR_11.21
						//BR_11.21
						if(lineItem.DonationType.DonationTypeCode == Common.Utility.GetDonationTypeCodeCharFromEnum(Common.DonationType.VolunteerAllogeneicDonor))
						{
							if(lineItem.BloodUnitMedia.DirectedPatientGuid != System.Guid.Empty)
							{
								BOL.BloodUnitMedia.ReleaseRestriction(lineItem, "Process outgoing shipment; release restrictionprior to shipment.", BOL.VBECSDateTime.GetDivisionCurrentDateTime(), LogonUser.LogonUserName, UpdateFunction.UC011FrmProcessShipmentOut);
								this._refreshLineItem = true;
							}
						}
					}
					ProcessConfirmShipment();
					
				} 
				else
				{
					return;
				}
			}
		}

		private void ProcessConfirmShipment()
		{
			try
			{
				if ( _currentInvoice.ConfirmShipment(_currentInvoice.ShipmentDate, Common.UpdateFunction.UC011FrmProcessShipmentOut, _workloadProcessID) )
				{
					_currentInvoice.Confirmed = true;
					GuiMessenger.ShowMessageBox(this, Common.StrRes.InfoMsg.UC011.InvoiceConfirmed());
					//Shipment has been confirmed, form is no longer dirty.
					this.IsDirty=false;
				}
			} 
			catch ( Exception ex )
			{
				ExceptionManagement.ExceptionManager.Publish(ex);
				GuiMessenger.ShowMessageBox(this, Common.StrRes.SysErrMsg.UC011.UpdateError()); 
				//Error occured and the form needs to close. Thus, the page is no longer
				//dirty.
				this.IsDirty=false;
				this.Close();
			}
		}
		//
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// User is selecting units for shipment
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		/// 
		private void bloodUnitSelector1_SearchClick(object sender, System.EventArgs e)
		{
			DoSearch();
		}
		//
    
		private void DoSearch()
		{
			using ( new WaitCursor() ) 
			{
				// BR_2.01
				DataTable eligDt = BOL.OutgoingShipmentCollection.GetEligibleUnitsForDivision();
				//
				DlgSelectBloodUnits unitSelector = new DlgSelectBloodUnits(eligDt, this.bloodUnitSelector1.EnteredEyeReadableUnitId, this.bloodUnitSelector1.EnteredUnitProductCode);
				unitSelector.TitleBarText = "VBECS - Select Units for Shipment";
				unitSelector.LogoBarText = "Select Units for Shipment";
				unitSelector.ShowDialogFromLockedParent(this,false);
				//
				if ( unitSelector.DialogResult == DialogResult.OK )
				{
					if (unitSelector.SelectedUnits.Rows.Count == 1)
					{
						try
						{
							DataRow dr = unitSelector.SelectedUnits.Rows[0];
							this.bloodUnitSelector1.PopulateSelector(dr[Common.VbecsTables.BloodUnit.EyeReadableUnitId].ToString(),
								dr[Common.DatabaseConstants.ArtificialColumnNames.FullProductCode].ToString());
						}
						catch(Exception exp)
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(exp.Message));
						}
					}
					else
					{
						foreach (DataRow dr in unitSelector.SelectedUnits.Rows) 
						{
							BOL.OutgoingShipmentCollection.LineItem lineItem = BOL.OutgoingShipmentCollection.LineItem.GetLineItemForUpdate((System.Guid)dr[Common.VbecsTables.BloodUnit.BloodUnitGuid]);
							//
							
							if ( VerifyUnitEligibleForShipment(lineItem) )
							{
								try
								{
									if( this._refreshLineItem )
									{
										//CR 3166
										lineItem = BOL.OutgoingShipmentCollection.LineItem.GetLineItemForUpdate(lineItem.BloodUnitGuid);
									}
									//	
									AddNewLineItemToListView(lineItem);
								} 
								catch ( Exception ex )
								{
									Debug.WriteLine(ex.Message + "\n" + ex.StackTrace);
								}
							}
						}
						VbecsFunction.SetColumnWidths(lvSelectedUnits);
					}
				}
				btnOK.EnabledButton = _currentInvoice.ReadyToSave;
				if (btnOK.EnabledButton) btnOK.SetToolTip(String.Empty);
				else btnOK.SetToolTip(FrmProcessShipmentOut.SaveBtnMessage);
			}
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// Determine if unit is eligible for shipment. User may decide.
		/// </summary>
		/// <param name="lineItem"></param>
		/// <returns></returns>
		private bool VerifyUnitEligibleForShipment(BOL.OutgoingShipmentCollection.LineItem lineItem)
		{
			// We do not refresh the unit data unless necessary (see BR_11.05 ref)
			this._refreshLineItem = false;
			//
			if ( _currentInvoice.Confirmed )
			{
				return false;
			}
			// BR_11.15
			if ( lineItem.BloodUnitStatus.QuarantineIndicator == true)
			{
				if (GuiMessenger.ShowMessageBox(this, Common.StrRes.ConfMsg.UC011.QuarantinedUnit(lineItem.EyeReadableUnitId)) != DialogResult.Yes)
				{
					return false;
				}
			}
			//
			if ( !(lineItem.BloodUnitFinance.OutgoingShipmentGuid == Guid.Empty) )
			{
				if ( lineItem.BloodUnitFinance.OutgoingShipmentGuid != _currentInvoice.ShipmentGuid )
				{
					BOL.OutgoingShipmentCollection tmpInvc = BOL.OutgoingShipmentCollection.GetOutgoingInvoiceByGuid(lineItem.BloodUnitFinance.OutgoingShipmentGuid);
					//
					GuiMessenger.ShowMessageBox(this, Common.StrRes.InfoMsg.UC011.RemoveUnitBeforeAdding(lineItem.EyeReadableUnitId, tmpInvc.InvoiceNumber, tmpInvc.LocalSupplier.FacilityName));
					tmpInvc = null;
					return false;
				}
			} 
			else
			{
				if (lineItem.IsReadOnly && lineItem.BloodUnitFinance.OutgoingShipmentGuid == Guid.Empty) 
				{
					GuiMessenger.ShowMessageBox(this, Common.StrRes.InfoMsg.UC011.UnitInUse(lineItem.EyeReadableUnitId));
					return false;
				}
				//
				if (lineItem.IsReadOnly && lineItem.BloodUnitFinance.OutgoingShipmentGuid == _currentInvoice.ShipmentGuid) 
				{
					GuiMessenger.ShowMessageBox(this, Common.StrRes.InfoMsg.UC011.UnitInUseCannotBeModified(lineItem.EyeReadableUnitId));
				}
			}
			// BR_11.03
			if ( !lineItem.DivisionCode.TrimEnd().Equals(LogonUser.LogonUserDivisionCode.TrimEnd()) )
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC011.DivisionCheck());
				return false;
			}
			//
			// If the user chose 'Return to Shipper', we need to verify 
			// the shipper they have chosen is the same one the unit came from
			if(this._currentInvoice.ShipmentType.Equals(Common.ShipmentType.ReturnToSupplier))
			{
				//CR 3193
				System.Data.DataTable dt = BOL.BaseShipment.GetOriginalBloodUnitShipper(lineItem.BloodUnitGuid);
				System.Guid localSupplierGuid = System.Guid.Empty;
				string localFacilityName = string.Empty;
				if(dt.Rows.Count >0)
				{
					localSupplierGuid = (System.Guid)dt.Rows[0][Common.VbecsTables.LocalSupplier.LocalSupplierGuid];
					localFacilityName = dt.Rows[0][Common.VbecsTables.LocalSupplier.FacilityName].ToString();
				}
				if (!this._currentInvoice.LocalSupplierGuid.Equals( localSupplierGuid ))
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC011.UnitNotValidForShipmentFacility(this._currentInvoice.LocalSupplier.FacilityName, localFacilityName));
					return false;
				}
			}
			//
			BOL.OutgoingShipmentCollection.ValidStatus validStatus = BOL.OutgoingShipmentCollection.EligibleUnitStatus(lineItem.BloodUnitStatus.UnitStatusCode);
			//
			if ( validStatus == BOL.OutgoingShipmentCollection.ValidStatus.No )
			{
				GuiMessenger.ShowMessageBox(this, Common.StrRes.InfoMsg.UC011.UnitInvalidForShipment(lineItem.EyeReadableUnitId));
				return false;
			}
			// BR_11.12
			if ( (lineItem.BloodUnitMedia.UnitExpirationDate.CompareTo(_currentInvoice.LastUpdateDate) < 0 ) )
			{
				if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC011.ExpiredUnit(lineItem.EyeReadableUnitId, lineItem.BloodUnitMedia.UnitExpirationDate.ToString())) != DialogResult.Yes)
				{
					return false;
				}
			}
			// BR_11.05
			if ( lineItem.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.CrossmatchedAssigned || lineItem.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Assigned )
			{
				// release assignments now or later ( when shipment is confirmed )
				if (GuiMessenger.ShowMessageBox(this, Common.StrRes.ConfMsg.UC011.CrossmatchedUnit(lineItem.EyeReadableUnitId)) == DialogResult.Yes)
				{
					// CR 2941
					Guid bloodUnitGuid = lineItem.BloodUnitGuid;
					Guid patientGuid = Guid.Empty;
					DataTable dtOrderedUnits = OrderedUnit.GetOrderedUnit( bloodUnitGuid, Common.LogonUser.LogonUserDivisionCode );

					DataTable dtBCEMessages = null;
					DataTable dtTempBCEMessages = null;

					//CR 2941
					//CR 2945
					//generate table with BCE_MESSAGE
					//Units are removed from assignment

					for ( int i = 0; i < dtOrderedUnits.Rows.Count; i++ )
					{
						patientGuid = BOL.OrderedUnit.GetPatientForOrderedUnit((Guid)dtOrderedUnits.Rows[i][VbecsTables.OrderedUnit.OrderedUnitGuid]);
						//CR 3015
						if (dtBCEMessages == null)
						{
							dtBCEMessages = OrderedUnit.UpdateBceForRelease(bloodUnitGuid, patientGuid, false);
						}
						else
						{
							dtTempBCEMessages = OrderedUnit.UpdateBceForRelease(bloodUnitGuid, patientGuid, false);
							if (dtTempBCEMessages.Rows.Count > 0)
								dtBCEMessages.Rows.Add(dtTempBCEMessages.Rows[0].ItemArray);
						}

					}
					//BCE_MESSAGE end

					// release assignments now 
					OrderedUnit.ReleaseOrderedUnits( lineItem, "Process outgoing shipment; release prior to shipment.", BOL.VBECSDateTime.GetDivisionCurrentDateTime(), LogonUser.LogonUserName, UpdateFunction.UC011FrmProcessShipmentOut, dtBCEMessages );
					this._refreshLineItem = true;
				}
				
				return true;
			}
			//
			if ( validStatus == BOL.OutgoingShipmentCollection.ValidStatus.Yes )
			{
				return true;
			}
			//
			return false;
		}

		/// <summary>
		/// Add a unit row to the ListView
		/// </summary>
		/// <param name="lineItem"></param>
		private void AddNewLineItemToListView(BOL.OutgoingShipmentCollection.LineItem lineItem)
		{
			if ( _currentInvoice[lineItem.BloodUnitGuid] != null )
			{
				GuiMessenger.ShowMessageBox(this, Common.StrRes.InfoMsg.UC011.DuplicateItem(lineItem.EyeReadableUnitId));
				return;
			}
			try
			{
				
				_currentInvoice.AddUnitToInvoice(lineItem);
				controls.VbecsFunction.SetColumnWidths(this.lvSelectedUnits);
			} 
			catch ( BOL.InvoiceException ex )
			{
				ExceptionManager.Publish(ex);
#if DEBUG
				GuiMessenger.ShowMessageBox(this, Common.StrRes.SysErrMsg.UC011.AddErrorDebug(ex.Message));              
#else
                GuiMessenger.ShowMessageBox(this, Common.StrRes.SysErrMsg.UC011.AddError()); 
#endif
				return;
			} 
			catch ( Exception ex )
			{
				ExceptionManager.Publish(ex);
#if DEBUG
				GuiMessenger.ShowMessageBox(this, Common.StrRes.SysErrMsg.UC011.AddErrorDebug(ex.Message)); 
#else
                GuiMessenger.ShowMessageBox(this, Common.StrRes.SysErrMsg.UC011.AddError()); 
#endif
				return;
			}
			//
			AddLineItemToListView(lineItem);
		}
		private void AddLineItemToListView(BOL.OutgoingShipmentCollection.LineItem lineItem)
		{
			ListViewItem lvi = new ListViewItem();
			lvi.Text = ""; 
			lvi.SubItems.Add(lineItem.EyeReadableUnitId);
			lvi.SubItems.Add(lineItem.ProductShortName);
			string quarantineIndicator = lineItem.BloodUnitStatus.QuarantineIndicator.ToString().ToUpper();
			string bioHazard = lineItem.BloodUnitStatus.BiohazardousWarningIndicator.ToString().ToUpper();
			if ( bioHazard == "TRUE" )
			{
				lvi.ImageIndex = 1;
				lvi.BackColor = Color.LightGray;
				lvi.ForeColor = Color.Black;
			} 
			else
			{
				lvi.ImageIndex = 0;
			}
			//
			lvi.SubItems.Add(lineItem.AboRh);
			lvi.SubItems.Add(Common.VBECSDateTime.FormatDateString(lineItem.BloodUnitMedia.UnitExpirationDate));
			lvi.SubItems.Add(lineItem.DonationType.DonationTypeText);
			lvi.SubItems.Add(lineItem.BloodUnitStatus.UnitStatusText);
			string unitInDate = Common.VBECSDateTime.FormatDateTimeString(lineItem.IncomingShipment.ShipmentDate);
			if ( unitInDate == "" )
			{
				unitInDate = Common.VBECSDateTime.FormatDateString(DateTime.MinValue);
			}
			lvi.SubItems.Add(unitInDate);
			string patientName = lineItem.PatientName;
			lvi.SubItems.Add(patientName.Trim());
			lvi.SubItems.Add(bioHazard == "TRUE" ? "Yes" : "");
			lvi.SubItems.Add(quarantineIndicator == "TRUE" ? "Yes" : "");
			lvi.SubItems.Add(GetReturnCredit(lineItem));
			lvi.Tag = lineItem;
			lvi.Checked = true;
			lvSelectedUnits.Items.Add(lvi);
			//An alteration to the data has occured. The form is now dirty.
			this.IsDirty=true;
		}

		private string GetReturnCredit(BOL.OutgoingShipmentCollection.LineItem lineItem)
		{
			string returnCredit = "";
			if ( _currentInvoice.ShipmentType == Common.ShipmentType.ReturnToSupplier )
			{
				if ( lineItem.BloodUnitFinance.ReturnCreditAmount == 0.0m )
				{
					if ( _currentInvoice.ShipmentType == Common.ShipmentType.ReturnToSupplier )
					{
						if ( !(lineItem.BloodUnitFinance.UnitCost == 0.0m) )
						{
							lineItem.BloodUnitFinance.ReturnCreditAmount = lineItem.BloodUnitFinance.UnitCost;
							returnCredit = lineItem.BloodUnitFinance.ReturnCreditAmount.ToString("N");
						}
					}
				}
			} 
			else
			{
				if (lineItem.BloodUnitFinance.ReturnCreditAmount != decimal.MinValue) 
				{
					returnCredit = lineItem.BloodUnitFinance.ReturnCreditAmount.ToString("N");
				}
			}
			return returnCredit;
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// User has selected an individual unit
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void bloodUnitSelector1_SelectBtnClick(object sender, System.EventArgs e)
		{
			try
			{
				BOL.OutgoingShipmentCollection.LineItem lineItem = BOL.OutgoingShipmentCollection.LineItem.GetLineItemForUpdate(bloodUnitSelector1.BloodUnit.BloodUnitGuid);
				
				//CR1736 - Need to lock the BloodUnitStatus record to prevent UCs from modifying a unit being shipped out
				if (this.SetLocks(lineItem.BloodUnitFinance.BloodUnitFinanceGuid, lineItem.BloodUnitStatus.BloodUnitStatusGuid))
				{
					if ( VerifyUnitEligibleForShipment(lineItem) )
					{
						if( this._refreshLineItem )
						{
							lineItem = BOL.OutgoingShipmentCollection.LineItem.GetLineItemForUpdate(bloodUnitSelector1.BloodUnit.BloodUnitGuid);
						}
						AddNewLineItemToListView(lineItem);
						VbecsFunction.SetColumnWidths(lvSelectedUnits);
						this.bloodUnitSelector1.Clear(false);
					}
					else
					{
						//CR1736 - Release the new BloodUnitStatus lock
						this.ReleaseLocks(lineItem.BloodUnitFinance.BloodUnitFinanceGuid, lineItem.BloodUnitStatus.BloodUnitStatusGuid);
					}
				}
			} 
			catch ( InvoiceException ex )
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(ex.Message));
			} 
			catch ( Exception )
			{
			}
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// User has unchecked a unit row, may want to remove it.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvSelectedUnits_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			int eIndex = e.Index;
			ListViewItem lvi = lvSelectedUnits.Items[e.Index];
			OutgoingShipmentCollection.LineItem li = ((OutgoingShipmentCollection.LineItem)lvi.Tag);

			if ( e.NewValue == CheckState.Checked )
			{
				//CR1736 - Need to lock the BloodUnitStatus record to prevent UCs from modifying a unit being shipped out
				if (!this.SetLocks(li.BloodUnitFinance.BloodUnitFinanceGuid, li.BloodUnitStatus.BloodUnitStatusGuid))
				{
					e.NewValue = CheckState.Unchecked;

					// Clear unit data
					this.bloodUnitSelector1.Clear( false );
					
					//If the user is trying to check a unit that they've unchecked already upon entry 
					//into the use case -- we don't want to remove it from the grid completely
					if (this._existingUnits.Contains(li.BloodUnitFinance.BloodUnitFinanceGuid))
					{
						return;
					}
				    _removeItem = true;
					RemoveItem(lvi, true);
					_currentInvoice.IsDirty = true;
				}
			}
			else
			{
			    _removeItem = true;
				if (RemoveItem(lvi, false))
				{
					//CR1736 - Release out BloodUnitStatus lock
					this.ReleaseLocks(li.BloodUnitFinance.BloodUnitFinanceGuid, li.BloodUnitStatus.BloodUnitStatusGuid);
				}
				else
				{
					e.NewValue = CheckState.Checked;
				    _removeItem = false;
				}
				//An alteration to the data on the form has occured.
				//The form is now dirty.
				this.IsDirty = true;
				_currentInvoice.IsDirty = true;
			}
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// User wants to sort the listed units by column
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvSelectedUnits_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			// Expiration and UnitIn dates
			if ( e.Column == 4 || e.Column ==7 )
			{
				ColumnClickSorter.ColumnClickHandler(sender, e, lvSelectedUnits.CheckBoxes, ColumnClickSorter.ColumnSortType.DateTime);
			} 
			else
			{
				// Return Credit
				if ( e.Column == 11 )
				{
					ColumnClickSorter.ColumnClickHandler(sender, e, lvSelectedUnits.CheckBoxes, ColumnClickSorter.ColumnSortType.Float);
				} 
				else
				{
					ColumnClickSorter.ColumnClickHandler(sender, e, lvSelectedUnits.CheckBoxes, ColumnClickSorter.ColumnSortType.String);
				}
			}
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// User has clicked the return credit menu item
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void menuItemReturnCredit_Click(object sender, System.EventArgs e)
		{
			if ( lvSelectedUnits.SelectedItems.Count > 0 )
			{
				ListViewItem lvi = lvSelectedUnits.SelectedItems[0];
				ModifyReturnCredit(lvi);
			}
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// Present the Return Credit Modification dialog
		/// </summary>
		/// <param name="lvi"></param>
		private void ModifyReturnCredit(ListViewItem lvi)
		{
			DlgModifyReturnCredit dlgRC = new DlgModifyReturnCredit(lvi);

            dlgRC.ShowDialogFromLockedParent(this, false);
			if (dlgRC.DialogResult != DialogResult.Cancel)
			{
				_currentInvoice.ModifyReturnCredit((OutgoingShipmentCollection.LineItem)lvi.Tag,
					decimal.Parse(dlgRC.ReturnCreditAmount));
			}
			VbecsFunction.SetColumnWidths(lvSelectedUnits);
			lvSelectedUnits.Focus();
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// Present tooltip warning info for the unit under the mouse
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvSelectedUnits_MouseMove(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			ListViewItem lvi = lvSelectedUnits.GetItemAt(e.X,e.Y);
			if ( lvi != null )
			{
				ArrayList tipText = new ArrayList();
				if ( lvi.SubItems[9].Text == "Yes" )
				{
					tipText.Add("Biohazardous Unit");
				}
				if ( lvi.SubItems[10].Text == "Yes" )
				{
					tipText.Add("Quarantined Unit");
				}
				if ( DateTime.Parse(lvi.SubItems[4].Text).CompareTo(BOL.VBECSDateTime.GetDivisionCurrentDateTime()) < 0 )
				{
					tipText.Add("Expired Unit");
				}
				string tipString = "";
				string comma = "";
				foreach ( string tip in tipText  )
				{
					tipString += comma + tip;
					comma = "\n";
				}

                //CR 3282 Setting tooltip on listview item instead of a listview
                lvSelectedUnits.ShowItemToolTips = true;
			    lvi.ToolTipText = tipString;
			} 
		}
		//
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// Remove an item from the shipment
		/// </summary>
		/// <param name="lvi"></param>
		/// <param name="bypassMessage">used for locking -- we just want to remove the line</param>
		/// <returns></returns>
		private bool RemoveItem(ListViewItem lvi, bool bypassMessage)
		{
			if ( lvi != null && !_currentInvoice.Confirmed )
			{
				try
				{
					DialogResult dRes = DialogResult.No;
					
					if (!bypassMessage)
					{
						dRes = GuiMessenger.ShowMessageBox(this, Common.StrRes.ConfMsg.UC011.RemoveUnit());
					}
					else
					{
						dRes = DialogResult.Yes;
					}

					//
					if ( dRes == DialogResult.Yes )
					{
						if ( lvi.Tag != null )
						{
							OutgoingShipmentCollection.LineItem lineItem = (OutgoingShipmentCollection.LineItem)lvi.Tag;
							_currentInvoice.RemoveUnitFromInvoice(lineItem);
						}
                        if (_removeItem == false)
                        {
                            lvi.Tag = null;
                            lvSelectedUnits.Items.Remove(lvi);
                            lvi = null;
                            lvSelectedUnits.Refresh();
                        }
					    //CR 1441
						System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) Common.WorkloadProcessID.UnitLogout);
						if(dt!= null)
						{
							if(dt.Rows.Count == 0)
							{
								GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
							}
						}
						return true;
					} 
					else
					{
						return false;
					}
					
				}
#if DEBUG
				catch (RowVersionException)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());				
				}
				
				catch ( Exception ex )
				{
					Debug.WriteLine(ex.Message + "\n" + ex.StackTrace);
				}
#else
                catch ( Exception )
                {
                    // Ignore it
                }
#endif
			}
			return true;

		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// User has selected the remove menu item
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void menuItemRemoveUnit_Click(object sender, System.EventArgs e)
		{
			if ( lvSelectedUnits.SelectedItems.Count > 0 && !_currentInvoice.Confirmed )
			{
				ListViewItem lvi = lvSelectedUnits.SelectedItems[0];
				RemoveItem(lvi, false);
			}
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// Determine if appropriate to display menu
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvSelectedUnits_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
		{

			if ( lvSelectedUnits.GetItemAt(e.X,e.Y) == null || _currentInvoice.Confirmed )
			{
				foreach(MenuItem mi in menuUnitItem.MenuItems)
				{
					mi.Visible = false;
				}
			} 
			else
			{
				foreach(MenuItem mi in menuUnitItem.MenuItems)
				{
					mi.Visible = true;
				}
			}
			if ( !(_currentInvoice.ShipmentType == Common.ShipmentType.ReturnToSupplier) )
			{
				menuItemReturnCredit.Visible = false;
			}

		}
		//
		private void lvSelectedUnits_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			Debug.WriteLine(e.KeyCode.ToString() + " " + e.KeyData.ToString() + " " + e.KeyValue.ToString());
		}
		//
		private void FrmProcessShipmentOut_Load(object sender, System.EventArgs e)
		{
			//Setting dirty variable as false to start out the process.
			this.IsDirty=false;
		}
		//
		private void lvSelectedUnits_MouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
		{

		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///		
		/// <summary>
		/// User has clicked the Print button
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnPrintInvoice_Click(object sender, System.EventArgs e)
		{
			using ( new WaitCursor() ) 
			{
				PrintShipment();
			}
		}
		//
		private void btnCancelShipment_Click(object sender, System.EventArgs e)
		{
			using (new WaitCursor()) 
			{
				if ( !this._currentInvoice.Confirmed )
				{
					//
					DialogResult dRes = GuiMessenger.ShowMessageBox(this, Common.StrRes.ConfMsg.UC011.RemoveAllUnits());
					//
					if ( dRes  == DialogResult.Yes )
					{
						_currentInvoice.Canceled = true;
					}
				}
			}
		}
		//
		private void FrmProcessShipmentOut_Resize(object sender, System.EventArgs e)
		{
			if (this.Size.Height < this.MinimumSize.Height || this.Size.Width < this.MinimumSize.Width) 
			{
				this.Size = this.MinimumSize;
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmProcessShipmentOut_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			textToSpeak = this.bloodUnitSelector1.GetErrorMessages();
			//
			if ( this.bloodUnitSelector1.BloodUnit == null && textToSpeak == string.Empty )
			{
				textToSpeak = string.Concat(textToSpeak, Common.StrRes.Tooltips.Common.SelectBloodUnit().ResString);
			}	
			else if ( !this.btnOK.EnabledButton )
			{
				textToSpeak =  string.Concat(textToSpeak, this.ttToolTip.GetToolTip(btnOK));
			}
			//
			this.SpeakMessage( textToSpeak );
		}

		private void lvSelectedUnits_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.SpeakListViewWithCheckBox(lvSelectedUnits);
		}

        private void lvSelectedUnits_ItemChecked(object sender, ItemCheckedEventArgs e)
        {
            if (_removeItem)
            {
                ((ListView)sender).Items.Remove(e.Item);
                _removeItem = false;
            }
        }
	}
}
